<?php

namespace App\Modules\LeadBookingTourPassenger\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingTourPassengerUpdaterQuery implements Query
{
    public function __construct(
        private string $id,
        private int $status,
        private int $idLeadBookingTour,
        private int $idLeadPassenger
    ) {
    }

    public function getId(): string
    {
        return $this->id;
    }
    public function getStatus(): int
    {
        return $this->status;
    }
    public function getIdLeadBookingTour(): string
    {
        return $this->idLeadBookingTour;
    }
    public function getIdLeadPassenger(): string
    {
        return $this->idLeadPassenger;
    }
}
