<?php

namespace App\Modules\LeadBookingTour\Domain;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Tour\Domain\IdTour;

class UpdateLeadBookingTour
{

    /** constructor */
    public function __construct(
        private LeadBookingTourDateStart $dateStart,
        private LeadBookingTourPickUp $pickUp,
        private LeadBookingTourType $type,
        private LeadBookingTourNoPax $noPax,
        private LeadBookingTourStatus $status,
        private ?IdLeadBookingTour $id = null
    ) {
    }
    public function getDateStart(): LeadBookingTourDateStart
    {
        return $this->dateStart;
    }
    public function getPickUp(): LeadBookingTourPickUp
    {
        return $this->pickUp;
    }
    public function getType(): LeadBookingTourType
    {
        return $this->type;
    }
    public function getNoPax(): LeadBookingTourNoPax
    {
        return $this->noPax;
    }
    public function getStatus(): LeadBookingTourStatus
    {
        return $this->status;
    }
    public function getId(): IdLeadBookingTour
    {
        return $this->id;
    }
}
