<?php

namespace App\Modules\LeadBookingTour\Application\Create;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBookingTour\Domain\LeadBookingTour;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourAddress;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourContactName;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourContactPhone;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourDateStart;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourEmail;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGender;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourGroup;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourLastName;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourName;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourNoDocument;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourNoPax;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourPhone;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourPhoneCode;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourPickUp;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourStatus;
use App\Modules\LeadBookingTour\Domain\LeadBookingTourType;
use App\Modules\Package\Domain\IdPackage;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Tour\Domain\IdTour;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class LeadBookingTourInserterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingTourInserter $inserter)
    {
    }

    public function __invoke(LeadBookingTourInserterQuery $query): LeadBookingTourInserterResponse
    {
        $model = new LeadBookingTour(
            new LeadBookingTourDateStart($query->getDateStart()),
            new LeadBookingTourPickUp($query->getPickUp()),
            new LeadBookingTourType($query->getType()),
            new LeadBookingTourNoPax($query->getNoPax()),
            new LeadBookingTourGroup($query->getGroup()),
            new LeadBookingTourStatus($query->getStatus()),
            new IdLeadBooking($query->getIdLeadBooking()),
            new IdPackage($query->getIdPackage()),
            new IdTour($query->getIdTour()),
        );
        return $this->inserter->__invoke($model);
    }
}
