<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Index;

use App\Modules\LeadBookingServicePassenger\Application\Index\LeadBookingServicePassengerIndexerResponse;
use App\Modules\LeadBookingServicePassenger\Domain\IdLeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;

final class LeadBookingServicePassengerIndexer
{
    public function __construct(private LeadBookingServicePassengerRepository $repository)
    {
    }

    public function __invoke(IdLeadBookingServicePassenger $idLeadBookingServicePassenger): LeadBookingServicePassengerIndexerResponse
    {
        return new LeadBookingServicePassengerIndexerResponse($this->repository->index($idLeadBookingServicePassenger));
    }
}
