<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Create;

use App\Modules\LeadBookingService\Domain\IdLeadBookingService;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerStatus;
use App\Modules\LeadBookingTourPassenger\Domain\IdLeadBookingTourPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServicePassengerInserterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServicePassengerInserter $inserter)
    {
    }

    public function __invoke(
        LeadBookingServicePassengerInserterQuery $query
    ): LeadBookingServicePassengerInserterResponse {
        $model = new LeadBookingServicePassenger(
            new LeadBookingServicePassengerStatus($query->getStatus()),
            new IdLeadBookingService($query->getIdLeadBookingService()),
            new IdLeadBookingTourPassenger($query->getIdLeadBookingTourPassenger()),
        );
        return $this->inserter->__invoke($model);
    }
}
