<?php

namespace App\Modules\LeadBookingServicePassenger\Application\Create;

use App\Modules\LeadBookingServicePassenger\Application\Create\LeadBookingServicePassengerInserterResponse;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassenger;
use App\Modules\LeadBookingServicePassenger\Domain\LeadBookingServicePassengerRepository;

final class LeadBookingServicePassengerInserter
{
    public function __construct(private LeadBookingServicePassengerRepository $repository)
    {
    }

    public function __invoke(
        LeadBookingServicePassenger $leadBookingServicePassenger
    ): LeadBookingServicePassengerInserterResponse {
        return new LeadBookingServicePassengerInserterResponse($this->repository->insert($leadBookingServicePassenger));
    }
}
