<?php

namespace App\Modules\LeadBookingService\Application\Create;

use App\Modules\LeadBookingService\Domain\Id;
use App\Modules\LeadBookingService\Domain\LeadBookingService;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceQuantity;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceStatus;
use App\Modules\LeadBookingService\Domain\LeadBookingServiceType;
use App\Modules\LeadBookingTour\Domain\IdLeadBookingTour;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingServiceInserterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingServiceInserter $inserter)
    {
    }

    public function __invoke(LeadBookingServiceInserterQuery $query): LeadBookingServiceInserterResponse
    {
        $model = new LeadBookingService(
            new LeadBookingServiceQuantity($query->quantity()),
            new LeadBookingServiceType($query->type()),
            new LeadBookingServiceStatus($query->status()),
            new IdLeadBookingTour($query->idLeadBookingTour()),
            new Id($query->idService())
        );
        return $this->inserter->__invoke($model);
    }
}
