<?php

namespace App\Modules\LeadBookingService\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class LeadBookingServiceInserterQuery implements Query
{
    public function __construct(
        private int $quantity,
        private int $type,
        private int $status,
        private int $idLeadBookingTour,
        private int $idService
    ) {
    }

    public function quantity(): int
    {
        return $this->quantity;
    }
    public function type(): int
    {
        return $this->type;
    }
    public function status(): int
    {
        return $this->status;
    }
    public function idLeadBookingTour(): int
    {
        return $this->idLeadBookingTour;
    }
    public function idService(): int
    {
        return $this->idService;
    }
}
