<?php

namespace App\Modules\LeadBooking\Domain;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;

class LeadBooking
{

    /** constructor */
    public function __construct(
        private LeadBookingObservation $observation,
        private LeadBookingContact $contact,
        private LeadBookingCancellationReason $cancellationReason,
        private LeadBookingCancellationRemark $cancellationRemark,
        private LeadBookingStatus $status,
        private IdAdmin $idAdmin,
        private IdLanguage $idGuideLanguage,
        private IdLanguage $idLanguage,
        private IdLead $idLead,
        private ?IdLeadBooking $id = null
    ) {
    }
    public function getObservation(): LeadBookingObservation
    {
        return $this->observation;
    }
    public function getContact(): LeadBookingContact
    {
        return $this->contact;
    }
    public function getCancellationReason(): LeadBookingCancellationReason
    {
        return $this->cancellationReason;
    }
    public function getCancellationRemark(): LeadBookingCancellationRemark
    {
        return $this->cancellationRemark;
    }
    public function getStatus(): LeadBookingStatus
    {
        return $this->status;
    }
    public function getIdAdmin(): IdAdmin
    {
        return $this->idAdmin;
    }
    public function getIdGuideLanguage(): IdLanguage
    {
        return $this->idGuideLanguage;
    }
    public function getIdLanguage(): IdLanguage
    {
        return $this->idLanguage;
    }
    public function getIdLead(): IdLead
    {
        return $this->idLead;
    }
    public function getId(): IdLeadBooking
    {
        return $this->id;
    }
}
