<?php

namespace App\Modules\LeadBooking\Application\Update;

use App\Modules\Admin\Domain\IdAdmin;
use App\Modules\Language\Domain\IdLanguage;
use App\Modules\Lead\Domain\IdLead;
use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\LeadBooking\Domain\LeadBooking;
use App\Modules\LeadBooking\Domain\LeadBookingAddress;
use App\Modules\LeadBooking\Domain\LeadBookingCancellationReason;
use App\Modules\LeadBooking\Domain\LeadBookingCancellationRemark;
use App\Modules\LeadBooking\Domain\LeadBookingContact;
use App\Modules\LeadBooking\Domain\LeadBookingContactName;
use App\Modules\LeadBooking\Domain\LeadBookingContactPhone;
use App\Modules\LeadBooking\Domain\LeadBookingEmail;
use App\Modules\LeadBooking\Domain\LeadBookingGender;
use App\Modules\LeadBooking\Domain\LeadBookingLastName;
use App\Modules\LeadBooking\Domain\LeadBookingName;
use App\Modules\LeadBooking\Domain\LeadBookingNoDocument;
use App\Modules\LeadBooking\Domain\LeadBookingObservation;
use App\Modules\LeadBooking\Domain\LeadBookingPhone;
use App\Modules\LeadBooking\Domain\LeadBookingPhoneCode;
use App\Modules\LeadBooking\Domain\LeadBookingStatus;
use App\Modules\LeadBooking\Domain\LeadBookingType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

final class LeadBookingUpdaterQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingUpdater $updater)
    {
    }

    public function __invoke(LeadBookingUpdaterQuery $query): LeadBookingUpdaterResponse
    {
        $model = new LeadBooking(
            new LeadBookingObservation($query->getObservation()),
            new LeadBookingContact($query->getContact()),
            new LeadBookingCancellationReason($query->getCancellationReason()),
            new LeadBookingCancellationRemark($query->getCancellationRemark()),
            new LeadBookingStatus($query->getStatus()),
            new IdAdmin($query->getIdAdmin()),
            new IdLanguage($query->getIdGuideLanguage()),
            new IdLanguage($query->getIdLanguage()),
            new IdLead($query->getIdLead()),
            new IdLeadBooking($query->getId()),
        );
        return $this->updater->__invoke($model);
    }
}
