<?php

namespace App\Modules\LeadBooking\Application\Index;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class LeadBookingIndexerQueryHandler implements QueryHandler
{
    public function __construct(private LeadBookingIndexer $indexer)
    {
    }

    public function __invoke(LeadBookingIndexerQuery $query): LeadBookingIndexerResponse
    {
        return $this->indexer->__invoke(new IdLeadBooking($query->getId()));
    }
}
