<?php

namespace App\Modules\JwtToken\Infrastructure;

use App\Modules\JwtToken\Domain\JwtCode;
use App\Modules\JwtToken\Domain\JwtParams;
use App\Modules\JwtToken\Domain\JwtResource;
use Firebase\JWT\JWT;
use Firebase\JWT\Key;
use stdClass;

class JwtTokenRepository
{
    public function generate(JwtResource $resource, JwtParams $urlParams)
    {
        $expireHours = 1;
        $key = config('var.JWT_SECRET');
        $payload = [
            'res' => $resource,
            'prm' => $urlParams->__toString(),
            'iat' => time(),
            'nbf' => time() + $expireHours * 60 * 60
        ];

        $jwt = JWT::encode($payload, $key, 'HS256');
        return new JwtCode($jwt);
    }

    public function degenerate(JwtCode $jwt)
    {
        $key = config('var.JWT_SECRET');
        $decoded = JWT::decode($jwt->value(), new Key($key, 'HS256'));
        print_r($decoded);
        dd($decoded);

        // $decoded = JWT::decode($jwt->value(), new Key($key, 'HS256'), $headers = new stdClass());
        // print_r($headers);

        // $decoded_array = (array) $decoded;
        // JWT::$leeway = 60;
        // $decoded = JWT::decode($jwt->value(), new Key($key, 'HS256'));
    }
}
