<?php

namespace App\Modules\Invoice\Application\Index;

use App\Modules\Invoice\Domain\IdInvoice;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexInvoiceQueryHandler implements QueryHandler
{
    public function __construct(private InvoiceIndexer $indexer)
    {
    }

    public function __invoke(IndexInvoiceQuery $query): IndexInvoiceResponse
    {
        return $this->indexer->__invoke(new IdInvoice($query->getId()));
    }
}
