<?php

namespace App\Modules\Image\Application;

use App\Modules\Application\Domain\IdApplication;
use App\Modules\ApplicationConfig\Application\ApplicationConfigListing;
use App\Modules\ApplicationConfig\Application\ApplicationConfigListingObject;
use App\Modules\ApplicationConfig\Domain\ApplicationConfigRepository;
use App\Modules\Image\Domain\Image;
use App\Modules\Image\Domain\ImageExtension;
use App\Modules\Image\Domain\ImageFilesize;
use App\Modules\Image\Domain\ImageRepository;
use App\Modules\Image\Domain\ImageStatus;
use App\Modules\Image\Domain\ImageThumbUrl;
use App\Modules\Image\Domain\ImageUrl;
use App\Modules\Shared\Validator\Domain\ListInput;

class ConfigImageInserter {

    private ImageRepository $repository;
    private ApplicationConfigRepository $applicationConfigRepository;

    public function __construct(
        ImageRepository $repository,
        ApplicationConfigRepository $applicationConfigRepository
    ) {
        $this->repository = $repository;
        $this->applicationConfigRepository = $applicationConfigRepository;
    }

    public function __invoke (
        IdApplication $idApplication,
        $fnBasicImage,
        $idLanguage
    ) {
        $config = (new ApplicationConfigListingObject($this->applicationConfigRepository))->__invoke($idApplication);

        $basicImage = $fnBasicImage($config);

        return $this->repository->insert(
            new Image(
                new ImageUrl($basicImage->getUrl()),
                new ImageThumbUrl($basicImage->getThumbnail()),
                new ImageFilesize($basicImage->getFilesize()),
                new ImageExtension($basicImage->getExtension()),
                new ImageStatus(ImageStatus::INACTIVE)
            ),
            $idLanguage
        );
    }
}