<?php

namespace App\Modules\HtlTypeRoomBed\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlBed\Domain\HtlBed;
use App\Modules\HtlTypeRoom\Domain\IdHtlTypeRoom;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListHtlTypeRoomBed implements StorageCriteria
{

    public function __construct(
        private IdHtlTypeRoom $idHtlTypeRoom,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlTypeRoomBed::select('`htrb`');
        if ($this->action == 'all') {
            $where = '`htrb`.`HtlTypeRoomBed_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`htrb`.`HtlTypeRoomBed_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`htrb`.`HtlTypeRoomBed_Status` = 0';
        } else {
            $where = '`htrb`.`HtlTypeRoomBed_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_htl_type_room_bed` `htrb`
            WHERE $where
            AND `htrb`.`Id_HtlTypeRoom` = ?",
            [$this->idHtlTypeRoom->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
