<?php

namespace App\Modules\HtlCampSchedule\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateHtlCampScheduleQuery implements Query
{
    public function __construct(
        private int $id,
        private string $date,
        private string $dateSchedule,
        private int $fromCamp,
        private int $availability,
        private int $amountUsage,
        private int $lock,
        private int $idHtlCamp
    ) {
    }

    public function id(): int
    {
        return $this->id;
    }

    public function date(): string
    {
        return $this->date;
    }

    public function dateSchedule(): string
    {
        return $this->dateSchedule;
    }

    public function fromCamp(): int
    {
        return $this->fromCamp;
    }

    public function availability(): int
    {
        return $this->availability;
    }

    public function amountUsage(): int
    {
        return $this->amountUsage;
    }

    public function lock(): int
    {
        return $this->lock;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }
}
