<?php

namespace App\Modules\HtlCampSchedule\Application\Order;

class CalendarGenerator
{

    public function __invoke(
        string $dateStart,
        string $dateEnd,
    ) {
        $timeDateStart = strtotime($dateStart);
        $timeDateEnd = strtotime($dateEnd);
        $dayInSeconds = 86400;
        $dateArray = $this->createDateArray($timeDateStart, $timeDateEnd, $dayInSeconds);

        return $this->createDaysList($dateArray);
    }

    private function createDaysList($dateArray)
    {
        return array_map(
            fn ($curdate) => (object)[
                'date' => $curdate,
                'availability' => null,
                'value' => null,
            ],
            $dateArray
        );
    }

    public function createDateArray(int $initial, int $to, int $sumatory)
    {
        $arr = [];
        while ($initial <= $to) {
            $arr[] = date('Y-m-d 00:00:00', $initial);
            $initial += $sumatory;
        }
        return $arr;
    }
}
