<?php

namespace App\Modules\HtlCampLock\Domain;

use App\Modules\Shared\Domain\ErrorDictionary;
use App\Modules\Shared\Exceptions\BasicRequestException;

class HtlCampLockNotFound extends BasicRequestException
{
    public function __construct()
    {
        parent::__construct(
            404,
            ErrorDictionary::ERRORS['OWNER']['HTL_CAMP_LOCK']['HTL_CAMP_LOCK_FIND']['HTL_CAMP_LOCK_NOT_FOUND'],
            'Reserva de campamento no encontrado'
        );
    }
}
