<?php

namespace App\Modules\HtlCampBookingPassenger\Infrastructure;

use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\HtlCampBookingPassenger\Domain\ListByPassengerHtlCampBookingPassengerModel;
use App\Modules\HtlCampBookingPassenger\Domain\ListByScheduleHtlCampBookingPassengerModel;
use App\Modules\HtlCampBookingPassenger\Domain\ListHtlCampBookingPassengerModel;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use App\Modules\Shared\Infraestructure\DBRequester;

class MysqlHtlCampBookingPassengerRepository implements HtlCampBookingPassengerRepository
{

    public function find(StorageCriteria $criteria): HtlCampBookingPassenger | null
    {
        $data = $criteria->run();
        if ($data === null) {
            return null;
        }
        return HtlCampBookingPassenger::fromDTO($criteria->run());
    }

    public function searchAll(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => HtlCampBookingPassenger::fromDTO($btp), $criteria->run());
    }

    public function search(StorageCriteria $criteria): array
    {
        return array_map(fn ($btp) => ListHtlCampBookingPassengerModel::fromDTO($btp), $criteria->run());
    }

    public function searchBySchedule(StorageCriteria $criteria): array
    {
        return array_map(
            fn ($btp) => ListByScheduleHtlCampBookingPassengerModel::fromDTO($btp),
            $criteria->run()
        );
    }

    public function searchByPassenger(StorageCriteria $criteria): array
    {
        return array_map(
            fn ($btp) => ListByPassengerHtlCampBookingPassengerModel::fromDTO($btp),
            $criteria->run()
        );
    }

    public function insert(HtlCampBookingPassenger $value)
    {
        return DBRequester::requestInsert($value);
    }

    public function update(HtlCampBookingPassenger $value)
    {
        return DBRequester::requestUpdate($value);
    }
}
