<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListByScheduleHtlCampBookingPassenger implements StorageCriteria
{

    public function __construct(
        private IdHtlCampSchedule $idHtlCampSchedule,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBookingPassenger::select('`hcbp`');
        if ($this->action == 'all') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 0';
        } else {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 2';
        }
        return DB::select(
            "SELECT `hcbp`.`Id_HtlCampBookingPassenger`,
                `hcbp`.`HtlCampBookingPassenger_Status`,

                `i`.`Id_Invoice`,
                `i`.`Invoice_TotalPending`,
                `i`.`Invoice_TotalPay`,
                `i`.`Invoice_Total`,

                `p`.`Id_Passenger`,
                `p`.`Passenger_ImgDocument1`,
                `p`.`Passenger_Gender`,
                `p`.`Passenger_DOB`,
                `p`.`Passenger_Name`,
                `p`.`Passenger_LastName`,
                `p`.`Passenger_CheckedInStatus`,
                `p`.`Passenger_InfoStatus`,
                `p`.`Passenger_PaymentStatus`,

                `bt`.`BookingTour_DateStart`,
                `bt`.`BookingTour_TourDuration`,
                `bt`.`BookingTour_Status`,

                `btp`.`Id_BookingTourPassenger`,
                `btp`.`BookingTourPassenger_HasBeenPrinted`,
                `btp`.`BookingTourPassenger_Status`,

                `uc`.`Id_UserCountry`,
                `uc`.`UserCountry_Name`,
                `uc`.`UserCountry_Code`,
                `uc`.`UserCountry_PhoneCode`,
                `uc`.`UserCountry_Img`,
                `uc`.`UserCountry_Status`,

                `t`.`Id_Tour`,
                `t`.`Tour_Name`,
                `t`.`Tour_Code`,
                `t`.`Tour_Color`,

                `u`.`Id_User`,
                `u`.`User_Type`,

                `b`.`Id_Booking`,
                `b`.`Booking_Type`,
                `b`.`Booking_InPerson`,
                `b`.`Booking_Code`,
                `b`.`Id_Admin`,

                CONCAT('[', GROUP_CONCAT(JSON_OBJECT(
                    'Id_Group', `g`.`Id_Group`,
                    'Group_Name', `g`.`Group_Name`,
                    'Group_DateStart', `g`.`Group_DateStart`,
                    'Group_MasterType', `g`.`Group_MasterType`
                )), ']') AS `GroupList`,
                `g`.`Id_Group`,
                COUNT(`g`.`Id_Group`) AS `Group_Count`

            FROM `t_htl_camp_booking_passenger` `hcbp`
            INNER JOIN `t_htl_camp_booking` `hcb` ON `hcb`.`Id_HtlCampBooking` = `hcbp`.`Id_HtlCampBooking`
            INNER JOIN `t_booking_tour_passenger` `btp` ON `btp`.`Id_BookingTourPassenger` = `hcbp`.`Id_BookingTourPassenger`
            INNER JOIN `t_booking_tour` `bt` ON `bt`.`Id_BookingTour` = `btp`.`Id_BookingTour`
            INNER JOIN `t_tour` `t` ON `t`.`Id_Tour` = `bt`.`Id_Tour`
            INNER JOIN `t_passenger` `p` ON `p`.`Id_Passenger` = `btp`.`Id_Passenger`
            INNER JOIN `t_user_country` `uc` ON `uc`.`Id_UserCountry` = `p`.`Id_UserCountry`
            INNER JOIN `t_invoice` `i` ON `i`.`Id_Passenger` = `p`.`Id_Passenger`
            INNER JOIN `t_booking` `b` ON `b`.`Id_Booking` = `p`.`Id_Booking`
            INNER JOIN `t_user` `u` ON `u`.`Id_User` = `b`.`Id_User`
            LEFT JOIN `t_group_passenger` `gp` ON `gp`.`Id` = `btp`.`Id_BookingTourPassenger` AND `gp`.`GroupPassenger_Type` = 1
            LEFT JOIN  `t_group` AS `g`  ON `g`.`Id_Group` = `gp`.`Id_Group`
            WHERE `hcb`.`Id_HtlCampSchedule` = ?
            AND $where
            GROUP BY `hcbp`.`Id_HtlCampBookingPassenger`
            ORDER BY `b`.`Id_Booking`, `p`.`Passenger_Name`",
            [$this->idHtlCampSchedule->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
