<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\BookingTour\Domain\IdBookingTour;
use App\Modules\BookingTourPassenger\Domain\BookingTourPassengerStatus;
use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmount;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmountTotal;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDate;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingDateStart;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingLock;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingRemark;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingStatus;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\Passenger\Domain\PassengerLastName;
use App\Modules\Passenger\Domain\PassengerName;
use App\Modules\Passenger\Domain\PassengerOrder;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class ListByPassengerHtlCampBookingPassengerModel extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlCampBookingPassenger::class, 'Id_HtlCampBookingPassenger', 'primary'),
            new AggregateAttribute('weight', HtlCampBookingPassengerWeight::class, 'HtlCampBookingPassenger_Weight'),
            new AggregateAttribute('status', HtlCampBookingPassengerStatus::class, 'HtlCampBookingPassenger_Status'),
            new AggregateAttribute('idHtlCampBooking', IdHtlCampBooking::class, 'Id_HtlCampBooking'),
            new AggregateAttribute('idBookingTourPassenger', IdBookingTourPassenger::class, 'Id_BookingTourPassenger'),
            new AggregateAttribute('date', HtlCampBookingDate::class, 'HtlCampBooking_Date'),
            new AggregateAttribute('dateStart', HtlCampBookingDateStart::class, 'HtlCampBooking_DateStart'),
            new AggregateAttribute('amount', HtlCampBookingAmount::class, 'HtlCampBooking_Amount'),
            new AggregateAttribute('amountTotal', HtlCampBookingAmountTotal::class, 'HtlCampBooking_AmountTotal'),
            new AggregateAttribute('campBookingStatus', HtlCampBookingStatus::class, 'HtlCampBooking_Status'),
            new AggregateAttribute('lock', HtlCampBookingLock::class, 'HtlCampBooking_Lock'),
            new AggregateAttribute('remark', HtlCampBookingRemark::class, 'HtlCampBooking_Remark'),
            new AggregateAttribute('idHtlCampSchedule', IdHtlCampSchedule::class, 'Id_HtlCampSchedule'),
            new AggregateAttribute('idBookingTour', IdBookingTour::class, 'Id_BookingTour'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_camp_booking_passenger';
    }

    public function __construct(
        protected IdHtlCampBookingPassenger $id,
        protected HtlCampBookingPassengerWeight $weight,
        protected HtlCampBookingPassengerStatus $status,
        protected IdHtlCampBooking $idHtlCampBooking,
        protected IdBookingTourPassenger $idBookingTourPassenger,
        protected HtlCampBookingDate $date,
        protected HtlCampBookingDateStart $dateStart,
        protected HtlCampBookingAmount $amount,
        protected HtlCampBookingAmountTotal $amountTotal,
        protected HtlCampBookingStatus $campBookingStatus,
        protected HtlCampBookingLock $lock,
        protected HtlCampBookingRemark $remark,
        protected IdHtlCampSchedule $idHtlCampSchedule,
        protected IdBookingTour $idBookingTour
    ) {
    }

    public function id(): IdHtlCampBookingPassenger
    {
        return $this->id;
    }

    public function weight(): HtlCampBookingPassengerWeight
    {
        return $this->weight;
    }

    public function status(): HtlCampBookingPassengerStatus
    {
        return $this->status;
    }

    public function idHtlCampBooking(): IdHtlCampBooking
    {
        return $this->idHtlCampBooking;
    }

    public function idBookingTourPassenger(): IdBookingTourPassenger
    {
        return $this->idBookingTourPassenger;
    }

    public function date(): HtlCampBookingDate
    {
        return $this->date;
    }

    public function dateStart(): HtlCampBookingDateStart
    {
        return $this->dateStart;
    }

    public function amount(): HtlCampBookingAmount
    {
        return $this->amount;
    }

    public function amountTotal(): HtlCampBookingAmountTotal
    {
        return $this->amountTotal;
    }

    public function campBookingStatus(): HtlCampBookingStatus
    {
        return $this->campBookingStatus;
    }

    public function lock(): HtlCampBookingLock
    {
        return $this->lock;
    }

    public function remark(): HtlCampBookingRemark
    {
        return $this->remark;
    }

    public function idHtlCampSchedule(): IdHtlCampSchedule
    {
        return $this->idHtlCampSchedule;
    }

    public function idBookingTour(): IdBookingTour
    {
        return $this->idBookingTour;
    }
}
