<?php

namespace App\Modules\HtlCampBookingPassenger\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListByPassengerHtlCampBookingPassenger implements StorageCriteria
{

    public function __construct(
        private IdBookingTourPassenger $idBookingTourPassenger,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlCampBookingPassenger::select('`hcbp`');
        if ($this->action == 'all') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 0';
        } else if ($this->action == 'all_deleted') {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` IN (0, 1, 2)';
        } else {
            $where = '`hcbp`.`HtlCampBookingPassenger_Status` = 2';
        }
        return DB::select(
            "SELECT $select,
                `hcb`.`HtlCampBooking_Date`,
                `hcb`.`HtlCampBooking_DateStart`,
                `hcb`.`HtlCampBooking_Amount`,
                `hcb`.`HtlCampBooking_AmountTotal`,
                `hcb`.`HtlCampBooking_Status`,
                `hcb`.`HtlCampBooking_Lock`,
                `hcb`.`HtlCampBooking_Remark`,
                `hcb`.`Id_HtlCampSchedule`,
                `hcb`.`Id_BookingTour`
            FROM `t_htl_camp_booking_passenger` `hcbp`
            INNER JOIN `t_htl_camp_booking` `hcb` ON `hcb`.`Id_HtlCampBooking` = `hcbp`.`Id_HtlCampBooking`
            WHERE `hcbp`.`Id_BookingTourPassenger` = ?
            AND $where
            GROUP BY `hcbp`.`Id_HtlCampBookingPassenger`",
            [$this->idBookingTourPassenger->value()]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
