<?php

namespace App\Modules\HtlCampBookingPassenger\Application\Update;

use App\Modules\HtlCampBooking\Application\ReloadAmount\ReloadAmountHtlCampBookingQuery;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassenger;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerRepository;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;

final class HtlCampBookingPassengerUpdater
{
    public function __construct(
        private HtlCampBookingPassengerRepository $repository,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(HtlCampBookingPassenger $model)
    {
        $update = $this->repository->update($model);
        $this->queryBus->ask(new ReloadAmountHtlCampBookingQuery($model->idHtlCampBooking()->value()));
        return $update;
    }
}
