<?php

namespace App\Modules\HtlCampBooking\Application\ReloadAmount;

use App\Modules\HtlCampBooking\Application\Index\HtlCampBookingIndexer;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmount;
use App\Modules\HtlCampBooking\Domain\HtlCampBookingAmountTotal;
use App\Modules\HtlCampBooking\Domain\IdHtlCampBooking;
use App\Modules\HtlCampBookingPassenger\Application\List\ListHtlCampBookingPassengerQuery;
use App\Modules\HtlCampBookingPassenger\Application\List\ListHtlCampBookingPassengerResponses;
use App\Modules\HtlCampBookingPassenger\Domain\HtlCampBookingPassengerStatus;
use App\Modules\HtlCampSchedule\Application\ReloadAmount\ReloadAmountHtlCampScheduleQuery;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ReloadAmountHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(
        private HtlCampBookingAmountReloader $updater,
        private HtlCampBookingIndexer $indexer,
        private QueryBus $queryBus
    ) {
    }

    public function __invoke(ReloadAmountHtlCampBookingQuery $query)
    {
        $index = $this->indexer->__invoke(new IdHtlCampBooking($query->id()), true);
        /** @var ListHtlCampBookingPassengerResponses $passengers */
        $passengers = $this->queryBus->ask(new ListHtlCampBookingPassengerQuery($index->id()->value(), 'all'));
        $amount = $index->amount()->value();
        $amountTotal = $index->amountTotal()->value();
        $newAmount = $this->getPassengersAmount($passengers->data());
        $newAmountTotal = $this->getPassengersAmountTotal($passengers->data());
        if ($amount !== $newAmount || $amountTotal !== $newAmountTotal) {
            $index->setAmount(new HtlCampBookingAmount($newAmount));
            $index->setAmountTotal(new HtlCampBookingAmountTotal($newAmountTotal));
            $this->updater->__invoke($index);
            $this->queryBus->ask(new ReloadAmountHtlCampScheduleQuery($index->idHtlCampSchedule()->value()));
        }
        return;
    }

    private function getPassengersAmount(array $passengers): int
    {
        return count(
            array_filter(
                $passengers,
                fn ($passenger) => $passenger->HtlCampBookingPassenger_Status === HtlCampBookingPassengerStatus::ACTIVE
            )
        );
    }

    private function getPassengersAmountTotal(array $passengers): int
    {
        return array_reduce(
            array_filter(
                $passengers,
                function ($passenger) {
                    return $passenger->HtlCampBookingPassenger_Status === HtlCampBookingPassengerStatus::ACTIVE
                        || $passenger->HtlCampBookingPassenger_Status === HtlCampBookingPassengerStatus::INACTIVE;
                }
            ),
            fn ($carry, $passenger) => $carry + $passenger->HtlCampBookingPassenger_Weight,
            0
        );
    }
}
