<?php

namespace App\Modules\HtlCampBooking\Application\ListBySchedule;

use App\Modules\HtlCampBooking\Application\HtlCampBookingResponse;
use App\Modules\HtlCampBooking\Application\HtlCampBookingResponses;
use App\Modules\HtlCampBooking\Domain\HtlCampBooking;
use App\Modules\HtlCampSchedule\Domain\IdHtlCampSchedule;
use App\Modules\HtlCampBooking\Domain\ListByScheduleHtlCampBookingModel;
use App\Modules\HtlCampBooking\Domain\ListHtlCampBookingModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListByScheduleHtlCampBookingQueryHandler implements QueryHandler
{
    public function __construct(private HtlCampBookingByScheduleLister $lister)
    {
    }

    public function __invoke(ListByScheduleHtlCampBookingQuery $query): HtlCampBookingResponses
    {
        return new HtlCampBookingResponses(...array_map(
            fn (ListHtlCampBookingModel $index) => new HtlCampBookingResponse(
                $index->id()->value(),
                $index->date()->value(),
                $index->dateStart()->value(),
                $index->amount()->value(),
                $index->status()->value(),
                $index->lock()->value(),
                $index->remark()->value(),
                $index->idHtlCampSchedule()->value(),
                $index->idBookingTour()->value(),
            ),
            $this->lister->__invoke(new IdHtlCampSchedule($query->getIdHtlCampSchedule()), $query->getAction())
        ));
    }
}
