<?php

namespace App\Modules\HtlCamp\Infraestructure;

class HtlCampValidators
{

    public static function insert()
    {
        return [
            'HtlCamp_Name'          => 'required|string|max:250',
            'HtlCamp_Abrv'          => 'required|string|max:10',
            'HtlCamp_Icon'          => 'image|mimes:' . config("var.MIME_IMG"),
            'HtlCamp_Availability'  => 'required|int',
            'HtlCamp_Status'        => 'required|int',
            'Id_HtlTypeCamp'        => 'required|int'
        ];
    }

    public static function update()
    {
        return [
            'Id_HtlCamp'            => 'required|int',
            'HtlCamp_Name'          => 'required|string|max:250',
            'HtlCamp_Abrv'          => 'required|string|max:10',
            'HtlCamp_Icon'          => 'image|mimes:' . config("var.MIME_IMG"),
            'HtlCamp_Availability'  => 'required|int',
            'HtlCamp_Order'         => 'required|int',
            'HtlCamp_Status'        => 'required|int',
            'Id_HtlTypeCamp'        => 'required|int'
        ];
    }

    public const list = [];
}
