<?php

namespace App\Modules\HtlBed\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListHtlBed implements StorageCriteria
{

    public function __construct(
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = HtlBed::select('`ftd`');
        if ($this->action == 'all') {
            $where = '`ftd`.`HtlBed_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`ftd`.`HtlBed_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`ftd`.`HtlBed_Status` = 0';
        } else {
            $where = '`ftd`.`HtlBed_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_htl_bed` `ftd`
            WHERE $where",
            []
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
