<?php

namespace App\Modules\HtlBed\Domain;

use App\Modules\HtlCamp\Domain\IdHtlCamp;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class HtlBed extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdHtlBed::class, 'Id_HtlBed', 'primary'),
            new AggregateAttribute('name', HtlBedName::class, 'HtlBed_Name'),
            new AggregateAttribute('description', HtlBedDescription::class, 'HtlBed_Description'),
            new AggregateAttribute('availability', HtlBedAvailability::class, 'HtlBed_Availability'),
            new AggregateAttribute('status', HtlBedStatus::class, 'HtlBed_Status'),
            new AggregateAttribute('idHtlCamp', IdHtlCamp::class, 'Id_HtlCamp'),
        ];
    }

    protected static function table(): string
    {
        return 't_htl_bed';
    }

    public function __construct(
        protected IdHtlBed $id,
        protected HtlBedName $name,
        protected HtlBedDescription $description,
        protected HtlBedAvailability $availability,
        protected HtlBedStatus $status,
        protected IdHtlCamp $idHtlCamp
    ) {
    }

    public function id(): IdHtlBed
    {
        return $this->id;
    }

    public function name(): HtlBedName
    {
        return $this->name;
    }

    public function description(): HtlBedDescription
    {
        return $this->description;
    }

    public function availability(): HtlBedAvailability
    {
        return $this->availability;
    }

    public function status(): HtlBedStatus
    {
        return $this->status;
    }

    public function idHtlCamp(): IdHtlCamp
    {
        return $this->idHtlCamp;
    }

    public function setName(HtlBedName $name): void
    {
        $this->name = $name;
    }

    public function setDescription(HtlBedDescription $description): void
    {
        $this->description = $description;
    }

    public function setAvailability(HtlBedAvailability $availability): void
    {
        $this->availability = $availability;
    }

    public function setStatus(HtlBedStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new HtlBedStatus(HtlBedStatus::DELETED);
    }
}
