<?php

namespace App\Modules\HtlBed\Application\Index;

use App\Modules\HtlBed\Application\HtlBedResponse;
use App\Modules\HtlBed\Domain\IdHtlBed;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexHtlBedQueryHandler implements QueryHandler
{
    public function __construct(private HtlBedIndexer $inserter)
    {
    }

    public function __invoke(IndexHtlBedQuery $query): HtlBedResponse
    {
        $model = $this->inserter->__invoke(new IdHtlBed($query->getId()));
        return new HtlBedResponse(
            $model->id()->value(),
            $model->name()->value(),
            $model->description()->value(),
            $model->availability()->value(),
            $model->status()->value(),
            $model->idHtlCamp()->value(),
        );
    }
}
