<?php

namespace App\Modules\HtlBed\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateHtlBedQuery implements Query
{
    public function __construct(
        private string $name,
        private string $description,
        private int $availability,
        private int $status,
        private int $idHtlCamp,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function description(): string
    {
        return $this->description;
    }

    public function availability(): int
    {
        return $this->availability;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idHtlCamp(): int
    {
        return $this->idHtlCamp;
    }
}
