<?php

namespace App\Modules\GroupProviderReview\Infraestructure;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProviderReview\Domain\GroupProviderReviewRepository;
use App\Modules\GroupProviderReview\Domain\IdGroupProviderReview;
use App\Modules\GroupProviderReview\Domain\InsertGroupProviderReview;
use App\Modules\GroupProviderReview\Domain\UpdateGroupProviderReview;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlGroupProviderReviewRepository implements GroupProviderReviewRepository
{

    public function groupFind(IdGroupProvider $idGroupProvider, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_review_list(?,@sts,@cod,@msg)',
            [
                $idGroupProvider->value()
            ]
        );
    }

    public function fromGroup(IdGroup $idGroup, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_review_list_froup_group(?,@sts,@cod,@msg)',
            [
                $idGroup->value()
            ]
        );
    }

    public function find(string $action, DateStart $dateStart, DateEnd $dateEnd)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_group_provider_review_list(?,?,?,@sts,@cod,@msg)',
            [
                $action,
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
    }

    public function index(IdGroupProviderReview $id)
    {
        return Requester::requestSelect(
            'CALL sp_group_provider_review_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(InsertGroupProviderReview $value)
    {
        return Requester::requestInsert(
            'CALL sp_group_provider_review_insert(?,?,@sts,@cod,@msg,@id)',
            [
                $value->getIdGroupProvider()->value(),
                $value->getIdQuestion()->getValue()
            ]
        );
    }

    public function update(UpdateGroupProviderReview $value)
    {
        return Requester::requestUpdate(
            'CALL sp_group_provider_review_update(?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->adminComment()->value(),
                $value->adminCommentIdAdmin()->value(),
            ]
        );
    }

    public function delete(IdGroupProviderReview $id)
    {
        return Requester::requestUpdate(
            'CALL sp_group_provider_review_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
