<?php

namespace App\Modules\GroupProviderReview\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

interface GroupProviderReviewRepository
{

    public function index(IdGroupProviderReview $id);
    public function groupFind(IdGroupProvider $idGroupProvider, string $action);
    public function fromGroup(IdGroup $idGroup, string $action);
    public function find(string $action, DateStart $dateStart, DateEnd $dateEnd);
    public function insert(InsertGroupProviderReview $value);
    public function update(UpdateGroupProviderReview $value);
    public function delete(IdGroupProviderReview $id);
}
