<?php

namespace App\Modules\GroupProviderReview\Application\ListFromGroup;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class GroupProviderReviewListFromGroupQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderReviewGroupLister $lister)
    {
    }

    public function __invoke(GroupProviderReviewListFromGroupQuery $query): GroupProviderReviewListFromGroupResponse
    {
        return $this->lister->__invoke(
            new IdGroup($query->idGroup()),
            $query->getAction()
        );
    }
}
