<?php

namespace App\Modules\GroupProviderMedia\Domain;

use App\Modules\BookingTourPassenger\Domain\IdBookingTourPassenger;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListGroupProviderMedia implements StorageCriteria
{

    public function __construct(
        private IdGroupProvider $idGroupProvider,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupProviderMedia::select('`gpm`');
        if ($this->action == 'all') {
            $where = '`gpm`.`GroupProviderMedia_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`gpm`.`GroupProviderMedia_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`gpm`.`GroupProviderMedia_Status` = 0';
        } else {
            $where = '`gpm`.`GroupProviderMedia_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_group_provider_media` `gpm`
            WHERE $where
            AND `gpm`.`Id_GroupProvider` = ?",
            [
                $this->idGroupProvider->value()
            ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
