<?php

namespace App\Modules\GroupProviderMedia\Application\Update;

use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\GroupProviderMedia\Application\Index\GroupProviderMediaIndexer;
use App\Modules\GroupProviderMedia\Domain\IdGroupProviderMedia;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaError;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaExtension;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaPath;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaPathLargeThumb;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaPathThumb;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaSize;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaStatus;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaType;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class UpdateGroupProviderMediaQueryHandler implements QueryHandler
{
    public function __construct(
        private GroupProviderMediaUpdater $updater,
        private GroupProviderMediaIndexer $indexer
    ) {
    }

    public function __invoke(UpdateGroupProviderMediaQuery $query): UpdateGroupProviderMediaResponse
    {
        $index = $this->indexer->__invoke(new IdGroupProviderMedia($query->id()), true);
        $index->setPath(new GroupProviderMediaPath($query->path()));
        $index->setPathThumb(new GroupProviderMediaPathThumb($query->pathThumb()));
        $index->setPathLargeThumb(new GroupProviderMediaPathLargeThumb($query->pathLargeThumb()));
        $index->setExtension(new GroupProviderMediaExtension($query->extension()));
        $index->setSize(new GroupProviderMediaSize($query->size()));
        $index->setType(new GroupProviderMediaType($query->type()));
        $index->setError(new GroupProviderMediaError($query->error()));
        $index->setStatus(new GroupProviderMediaStatus($query->status()));
        $this->updater->__invoke($index);
        return new UpdateGroupProviderMediaResponse();
    }
}
