<?php

namespace App\Modules\GroupProviderMedia\Application\Index;

use App\Modules\GroupProviderMedia\Domain\IdGroupProviderMedia;
use App\Modules\GroupProviderMedia\Domain\GroupProviderMediaRepository;
use App\Modules\GroupProviderMedia\Domain\IndexGroupProviderMedia;

final class GroupProviderMediaIndexer
{
    public function __construct(private GroupProviderMediaRepository $repository)
    {
    }

    public function __invoke(IdGroupProviderMedia $idGroupProviderMedia, bool $lockInShare = false)
    {
        $index = $this->repository->find(new IndexGroupProviderMedia($idGroupProviderMedia, $lockInShare));
        return $index;
    }
}
