<?php

namespace App\Modules\GroupProvider\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;
use App\Modules\TypeProvider\Domain\IdTypeProvider;

class GroupProvider extends AggregateRoot
{

    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdGroupProvider::class, 'Id_GroupProvider', 'primary'),
            new AggregateAttribute('type', GroupProviderType::class, 'GroupProvider_Type'),
            new AggregateAttribute('remark', GroupProviderRemark::class, 'GroupProvider_Remark'),
            new AggregateAttribute('answeredReview', GroupProviderAnsweredReview::class, 'GroupProvider_AnsweredReview'),
            new AggregateAttribute('mask', GroupProviderMask::class, 'GroupProvider_Mask'),
            new AggregateAttribute('isCloned', GroupProviderIsCloned::class, 'GroupProvider_IsCloned'),
            new AggregateAttribute('mediaDateUpdate', GroupProviderMediaDateUpdate::class, 'GroupProvider_MediaDateUpdate'),
            new AggregateAttribute('mediaStatus', GroupProviderMediaStatus::class, 'GroupProvider_MediaStatus'),
            new AggregateAttribute('mediaScore', GroupProviderMediaScore::class, 'GroupProvider_MediaScore'),
            new AggregateAttribute('mediaScoreDescription', GroupProviderMediaScoreDescription::class, 'GroupProvider_MediaScoreDescription'),
            new AggregateAttribute('idGroup', IdGroup::class, 'Id_Group'),
            new AggregateAttribute('idProvider', IdProvider::class, 'Id_Provider'),
            new AggregateAttribute('idTypeProvider', IdTypeProvider::class, 'Id_TypeProvider'),
            new AggregateAttribute('idStatusGroupProvider', IdStatusGroupProvider::class, 'Id_StatusGroupProvider'),
        ];
    }

    public static function table(): string
    {
        return 't_group_provider';
    }

    public function __construct(
        protected IdGroupProvider $id,
        protected GroupProviderType $type,
        protected GroupProviderRemark $remark,
        protected GroupProviderAnsweredReview $answeredReview,
        protected GroupProviderMask $mask,
        protected GroupProviderIsCloned $isCloned,
        protected GroupProviderMediaDateUpdate $mediaDateUpdate,
        protected GroupProviderMediaStatus $mediaStatus,
        protected GroupProviderMediaScore $mediaScore,
        protected GroupProviderMediaScoreDescription $mediaScoreDescription,
        protected IdGroup $idGroup,
        protected IdProvider $idProvider,
        protected IdTypeProvider $idTypeProvider,
        protected IdStatusGroupProvider $idStatusGroupProvider,
    ) {
    }

    public function id(): IdGroupProvider
    {
        return $this->id;
    }

    public function type(): GroupProviderType
    {
        return $this->type;
    }

    public function remark(): GroupProviderRemark
    {
        return $this->remark;
    }

    public function answeredReview(): GroupProviderAnsweredReview
    {
        return $this->answeredReview;
    }

    public function mask(): GroupProviderMask
    {
        return $this->mask;
    }

    public function isCloned(): GroupProviderIsCloned
    {
        return $this->isCloned;
    }

    public function mediaDateUpdate(): GroupProviderMediaDateUpdate
    {
        return $this->mediaDateUpdate;
    }

    public function mediaStatus(): GroupProviderMediaStatus
    {
        return $this->mediaStatus;
    }

    public function mediaScore(): GroupProviderMediaScore
    {
        return $this->mediaScore;
    }

    public function mediaScoreDescription(): GroupProviderMediaScoreDescription
    {
        return $this->mediaScoreDescription;
    }

    public function idGroup(): IdGroup
    {
        return $this->idGroup;
    }

    public function idProvider(): IdProvider
    {
        return $this->idProvider;
    }

    public function idTypeProvider(): IdTypeProvider
    {
        return $this->idTypeProvider;
    }

    public function idStatusGroupProvider(): IdStatusGroupProvider
    {
        return $this->idStatusGroupProvider;
    }

    public function setMediaStatus(GroupProviderMediaStatus $value)
    {
        $this->mediaStatus = GroupProviderMediaStatus::changeFrom($this->mediaStatus, $value);
    }

    public function setMediaDateUpdate(GroupProviderMediaDateUpdate $value)
    {
        $this->mediaDateUpdate = $value;
    }

    public function setMediaScore(GroupProviderMediaScore $value)
    {
        $this->mediaScore = $value;
    }
}
