<?php

namespace App\Modules\GroupProvider\Application\Report;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\GroupProvider\Domain\GroupProviderReportRepository;

final class GroupProviderReporter
{
    public function __construct(private GroupProviderReportRepository $repository)
    {
    }

    public function __invoke(
        GroupDateStart $dateStart,
        GroupDateEnd $dateEnd
    ): ReportGroupProviderResponse {
        return new ReportGroupProviderResponse($this->repository->report($dateStart, $dateEnd));
    }
}
