<?php

namespace App\Modules\GroupProvider\Application\Mask;

use App\Modules\GroupProvider\Domain\GroupProviderMask;
use App\Modules\GroupProvider\Domain\IdGroupProvider;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class MaskGroupProviderQueryHandler implements QueryHandler
{
    public function __construct(private GroupProviderMasker $masker)
    {
    }

    public function __invoke(MaskGroupProviderQuery $query): MaskGroupProviderResponse
    {
        return $this->masker->__invoke(
            new IdGroupProvider($query->id()),
            new GroupProviderMask($query->mask())
        );
    }
}
