<?php

namespace App\Modules\GroupPassengerMedia\Domain;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

class ListGroupPassengerMedia implements StorageCriteria
{

    public function __construct(
        private IdGroupPassenger $idGroupPassenger,
        private string $action
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupPassengerMedia::select('`gpm`');
        if ($this->action == 'all') {
            $where = '`gpm`.`GroupPassengerMedia_Status` IN (1, 2)';
        } else if ($this->action == 'active') {
            $where = '`gpm`.`GroupPassengerMedia_Status` = 2';
        } else if ($this->action == 'deleted') {
            $where = '`gpm`.`GroupPassengerMedia_Status` = 0';
        } else {
            $where = '`gpm`.`GroupPassengerMedia_Status` = 2';
        }
        return DB::select(
            "SELECT $select
            FROM `t_group_passenger_media` `gpm`
            WHERE $where
            AND `gpm`.`Id_GroupPassenger` = ?",
            [
                $this->idGroupPassenger->value()
            ]
        );
    }

    protected function analize($data)
    {
        return $data;
    }
}
