<?php

namespace App\Modules\GroupPassengerMedia\Domain;

use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class GroupPassengerMedia extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdGroupPassengerMedia::class, 'Id_GroupPassengerMedia', 'primary'),
            new AggregateAttribute('path', GroupPassengerMediaPath::class, 'GroupPassengerMedia_Path'),
            new AggregateAttribute('pathThumb', GroupPassengerMediaPathThumb::class, 'GroupPassengerMedia_Path_Thumb'),
            new AggregateAttribute('pathLargeThumb', GroupPassengerMediaPathLargeThumb::class, 'GroupPassengerMedia_Path_LargeThumb'),
            new AggregateAttribute('description', GroupPassengerMediaDescription::class, 'GroupPassengerMedia_Description'),
            new AggregateAttribute('extension', GroupPassengerMediaExtension::class, 'GroupPassengerMedia_Extension'),
            new AggregateAttribute('size', GroupPassengerMediaSize::class, 'GroupPassengerMedia_Size'),
            new AggregateAttribute('type', GroupPassengerMediaType::class, 'GroupPassengerMedia_Type'),
            new AggregateAttribute('hasThumbnail', GroupPassengerMediaHasThumbnail::class, 'GroupPassengerMedia_HasThumbnail'),
            new AggregateAttribute('error', GroupPassengerMediaError::class, 'GroupPassengerMedia_Error'),
            new AggregateAttribute('status', GroupPassengerMediaStatus::class, 'GroupPassengerMedia_Status'),
            new AggregateAttribute('idGroupPassenger', IdGroupPassenger::class, 'Id_GroupPassenger'),
        ];
    }

    protected static function table(): string
    {
        return 't_group_passenger_media';
    }

    public function __construct(
        protected IdGroupPassengerMedia $id,
        protected GroupPassengerMediaPath $path,
        protected GroupPassengerMediaPathThumb $pathThumb,
        protected GroupPassengerMediaPathLargeThumb $pathLargeThumb,
        protected GroupPassengerMediaDescription $description,
        protected GroupPassengerMediaExtension $extension,
        protected GroupPassengerMediaSize $size,
        protected GroupPassengerMediaType $type,
        protected GroupPassengerMediaHasThumbnail $hasThumbnail,
        protected GroupPassengerMediaError $error,
        protected GroupPassengerMediaStatus $status,
        protected IdGroupPassenger $idGroupPassenger,
    ) {
    }

    public function id(): IdGroupPassengerMedia
    {
        return $this->id;
    }
    public function path(): GroupPassengerMediaPath
    {
        return $this->path;
    }

    public function pathThumb(): GroupPassengerMediaPathThumb
    {
        return $this->pathThumb;
    }

    public function pathLargeThumb(): GroupPassengerMediaPathLargeThumb
    {
        return $this->pathLargeThumb;
    }

    public function description(): GroupPassengerMediaDescription
    {
        return $this->description;
    }

    public function extension(): GroupPassengerMediaExtension
    {
        return $this->extension;
    }

    public function size(): GroupPassengerMediaSize
    {
        return $this->size;
    }

    public function type(): GroupPassengerMediaType
    {
        return $this->type;
    }

    public function hasThumbnail(): GroupPassengerMediaHasThumbnail
    {
        return $this->hasThumbnail;
    }

    public function error(): GroupPassengerMediaError
    {
        return $this->error;
    }

    public function status(): GroupPassengerMediaStatus
    {
        return $this->status;
    }

    public function idGroupPassenger(): IdGroupPassenger
    {
        return $this->idGroupPassenger;
    }


    public function setPath(GroupPassengerMediaPath $path): void
    {
        $this->path = $path;
    }

    public function setPathThumb(GroupPassengerMediaPathThumb $pathThumb): void
    {
        $this->pathThumb = $pathThumb;
    }

    public function setPathLargeThumb(GroupPassengerMediaPathLargeThumb $pathLargeThumb): void
    {
        $this->pathLargeThumb = $pathLargeThumb;
    }

    public function setExtension(GroupPassengerMediaExtension $extension): void
    {
        $this->extension = $extension;
    }

    public function setSize(GroupPassengerMediaSize $size): void
    {
        $this->size = $size;
    }

    public function setType(GroupPassengerMediaType $type): void
    {
        $this->type = $type;
    }

    public function setError(GroupPassengerMediaError $error): void
    {
        $this->error = $error;
    }

    public function setStatus(GroupPassengerMediaStatus $status): void
    {
        $this->status = $status;
    }

    public function delete()
    {
        $this->status = new GroupPassengerMediaStatus(GroupPassengerMediaStatus::DELETED);
    }
}
