<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Storage\Criteria\StorageCriteria;
use Illuminate\Support\Facades\DB;

/**
 * @extends StorageCriteria<GroupPassenger>
 */
class ListGroupPassenger implements StorageCriteria
{

    public function __construct(
        private IdGroup $idGroup
    ) {
    }

    public function run()
    {
        return $this->analize($this->query());
    }

    protected function query()
    {
        $select = GroupPassengerModel::select('`ftd`');
        return DB::select(
            "SELECT $select
            FROM " . GroupPassengerModel::table() . " `ftd`
            WHERE Id_Group = ? ",
            [$this->idGroup->value()]
        );
    }

    protected function analize($data)
    {
        return array_map(fn ($data) => GroupPassengerModel::fromDTO($data), $data);
    }
}
