<?php

namespace App\Modules\GroupPassenger\Domain;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class GroupPassengerModel extends AggregateRoot
{


    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdGroupPassenger::class, 'Id_GroupPassenger', 'primary'),
            new AggregateAttribute('type', GroupPassengerType::class, 'GroupPassenger_Type'),
            new AggregateAttribute('notification', GroupPassengerNotification::class, 'GroupPassenger_Notification'),
            new AggregateAttribute('notificationAccepted', GroupPassengerNotificationAccepted::class, 'GroupPassenger_NotificationAccepted'),
            new AggregateAttribute('externalReview', GroupPassengerExternalReview::class, 'GroupPassenger_ExternalReview'),
            new AggregateAttribute('reviewStatus', GroupPassengerReviewStatus::class, 'GroupPassenger_ReviewStatus'),
            new AggregateAttribute('reviewDateUpdate', GroupPassengerReviewDateUpdate::class, 'GroupPassenger_ReviewDateUpdate'),
            new AggregateAttribute('mediaDateUpdate', GroupPassengerMediaDateUpdate::class, 'GroupPassenger_MediaDateUpdate'),
            new AggregateAttribute('mediaStatus', GroupPassengerMediaStatus::class, 'GroupPassenger_MediaStatus'),
            new AggregateAttribute('mediaScore', GroupPassengerMediaScore::class, 'GroupPassenger_MediaScore'),
            new AggregateAttribute('mediaScoreDescription', GroupPassengerMediaScoreDescription::class, 'GroupPassenger_MediaScoreDescription'),

            new AggregateAttribute('idGroup', IdGroup::class, 'Id_Group'),
            new AggregateAttribute('idAlter', GroupPassengerIdAlter::class, 'Id'),
        ];
    }

    public static function table(): string
    {
        return 't_group_passenger';
    }

    public function __construct(
        protected IdGroupPassenger $id,
        protected GroupPassengerType $type,
        protected GroupPassengerNotification $notification,
        protected GroupPassengerNotificationAccepted $notificationAccepted,
        protected GroupPassengerExternalReview $externalReview,
        protected GroupPassengerReviewStatus $reviewStatus,
        protected GroupPassengerReviewDateUpdate $reviewDateUpdate,
        protected GroupPassengerMediaDateUpdate $mediaDateUpdate,
        protected GroupPassengerMediaStatus $mediaStatus,
        protected GroupPassengerMediaScore $mediaScore,
        protected GroupPassengerMediaScoreDescription $mediaScoreDescription,
        protected IdGroup $idGroup,
        protected GroupPassengerIdAlter $idAlter,
    ) {
    }

    public function id(): IdGroupPassenger
    {
        return $this->id;
    }

    public function type(): GroupPassengerType
    {
        return $this->type;
    }

    public function notification(): GroupPassengerNotification
    {
        return $this->notification;
    }

    public function notificationAccepted(): GroupPassengerNotificationAccepted
    {
        return $this->notificationAccepted;
    }

    public function externalReview(): GroupPassengerExternalReview
    {
        return $this->externalReview;
    }

    public function reviewStatus(): GroupPassengerReviewStatus
    {
        return $this->reviewStatus;
    }

    public function reviewDateUpdate(): GroupPassengerReviewDateUpdate
    {
        return $this->reviewDateUpdate;
    }

    public function mediaDateUpdate(): GroupPassengerMediaDateUpdate
    {
        return $this->mediaDateUpdate;
    }

    public function mediaStatus(): GroupPassengerMediaStatus
    {
        return $this->mediaStatus;
    }

    public function mediaScore(): GroupPassengerMediaScore
    {
        return $this->mediaScore;
    }

    public function mediaScoreDescription(): GroupPassengerMediaScoreDescription
    {
        return $this->mediaScoreDescription;
    }

    public function idGroup(): IdGroup
    {
        return $this->idGroup;
    }

    public function idAlter(): GroupPassengerIdAlter
    {
        return $this->idAlter;
    }

    public function setMediaStatus(GroupPassengerMediaStatus $value)
    {
        $this->mediaStatus = GroupPassengerMediaStatus::changeFrom($this->mediaStatus, $value);
    }

    public function setMediaDateUpdate(GroupPassengerMediaDateUpdate $value)
    {
        $this->mediaDateUpdate = $value;
    }

    public function setMediaScore(GroupPassengerMediaScore $value)
    {
        $this->mediaScore = $value;
    }
}
