<?php

namespace App\Modules\GroupPassenger\Application\UpdateStatus;

use App\Modules\GroupPassenger\Application\Index\GroupPassengerIndexer;
use App\Modules\GroupPassenger\Domain\GroupPassengerMediaStatus;
use App\Modules\GroupPassenger\Domain\GroupPassengerModel;
use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerMediaDateUpdate;

final class StatusGroupPassengerUpdater
{
    public function __construct(
        private GroupPassengerRepository $repository,
        private GroupPassengerIndexer $groupPassengerIndexer
    ) {
    }

    public function __invoke(IdGroupPassenger $id, GroupPassengerMediaStatus $mediaStatus)
    {
        /** @var GroupPassengerModel $index */
        $index = $this->groupPassengerIndexer->__invoke($id);
        $index->setMediaStatus($mediaStatus);
        $index->setMediaDateUpdate(GroupPassengerMediaDateUpdate::reduceDatetimeToPeru(GroupPassengerMediaDateUpdate::now()));
        return $this->repository->updateModel($index);
    }
}
