<?php

namespace App\Modules\GroupPassenger\Application\UpdateReview;

use App\Modules\GroupPassenger\Domain\GroupPassengerRepository;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewDateUpdate;
use App\Modules\GroupPassenger\Domain\GroupPassengerReviewStatus;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;

final class GroupPassengerReviewUpdater
{
    public function __construct(private GroupPassengerRepository $repository)
    {
    }

    public function __invoke(
        IdGroupPassenger $id,
        GroupPassengerReviewStatus $reviewStatus,
        GroupPassengerReviewDateUpdate $reviewDateUpdate
    ): UpdateReviewGroupPassengerResponse {
        $groupPassenger = $this->repository->index($id);
        $groupPassenger->setReviewStatus($reviewStatus);
        $groupPassenger->setReviewDateUpdate($reviewDateUpdate);
        return new UpdateReviewGroupPassengerResponse($this->repository->update($groupPassenger));
    }
}
