<?php

namespace App\Modules\GroupPassenger\Application\List;

use App\Modules\Group\Domain\IdGroup;
use App\Modules\GroupPassenger\Application\GroupPassengerResponse;
use App\Modules\GroupPassenger\Application\GroupPassengerResponseList;
use App\Modules\GroupPassenger\Application\GroupPassengerResponses;
use App\Modules\GroupPassenger\Domain\GroupPassenger;
use App\Modules\GroupPassenger\Domain\GroupPassengerModel;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ListGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerLister $list)
    {
    }

    public function __invoke(ListGroupPassengerQuery $query): GroupPassengerResponses
    {
        return new GroupPassengerResponses(...array_map(
            fn (GroupPassengerModel $provider) => new GroupPassengerResponseList(
                $provider->id()->value(),
                $provider->type()->value(),
                $provider->notification()->value(),
                $provider->notificationAccepted()->value(),
                $provider->externalReview()->value(),
                $provider->reviewStatus()->value(),
                $provider->reviewStatus()->value(),
                $provider->reviewDateUpdate()->value(),
                $provider->mediaDateUpdate()->value(),
                $provider->mediaStatus()->value(),
                $provider->mediaScore()->value(),
                $provider->mediaScoreDescription()->value(),
                $provider->idGroup()->value(),
                $provider->idAlter()->value(),
            ),
            $this->list->__invoke(new IdGroup($query->idGroup()))
        ));
    }
}
