<?php

namespace App\Modules\GroupPassenger\Application\Index;

use App\Modules\GroupPassenger\Application\GroupPassengerResponse;
use App\Modules\GroupPassenger\Domain\IdGroupPassenger;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexGroupPassengerQueryHandler implements QueryHandler
{
    public function __construct(private GroupPassengerIndexer $indexer)
    {
    }

    public function __invoke(IndexGroupPassengerQuery $query): GroupPassengerResponse
    {
        $model = $this->indexer->__invoke(new IdGroupPassenger($query->id()));
        return new GroupPassengerResponse(
            $model->id()->value(),
            $model->type()->value(),
            $model->notification()->value(),
            $model->notificationAccepted()->value(),
            $model->externalReview()->value(),
            $model->reviewStatus()->value(),
            $model->reviewDateUpdate()->value(),
            $model->mediaStatus()->value(),
            $model->idGroup()->value(),
            $model->idAlter()->value(),
        );
    }
}
