<?php

namespace App\Modules\Group\Domain;

use App\Modules\Shared\Domain\QueryList\ListInput;

final class ReportGroupCounter {

    private ReportGroupRepository $repository;

    public function __construct(
        ReportGroupRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(GroupDateStart $dateStart, GroupDateEnd $dateEnd):int
    {
        $model = $this->repository->count($dateStart, $dateEnd);
        return $model;
    }
}
