<?php

namespace App\Modules\Group\Domain;

use App\Modules\CategoryTour\Domain\IdCategoryTour;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\StatusGroup\Domain\IdStatusGroup;
use App\Modules\Tour\Domain\IdTour;

interface GroupRepositoryAlter
{
    public function list(
        string $action,
        IdCategoryTour $idCategoryTour,
        IdTour $idTour,
        DateStart $dateStart,
        DateEnd $dateEnd,
        string $token
    );

    public function copyProviders(IdGroup $idGroup);

    public function updateStatus(IdGroup $idGroup, IdStatusGroup $idStatusGroup);

    public function updateDateUpdate(IdGroup $idGroup);
}
