<?php

declare(strict_types=1);

namespace App\Modules\Group\Application\Report;

use App\Modules\Group\Domain\GroupDateEnd;
use App\Modules\Group\Domain\GroupDateStart;
use App\Modules\Group\Domain\ReportGroupCounter as DomainReportGroupCounter;
use App\Modules\Group\Domain\ReportGroupId;
use App\Modules\Group\Domain\ReportGroupRepository;
use App\Modules\Shared\Domain\QueryList\ListInput;

final class ReportGroupCounter
{
    private DomainReportGroupCounter $finder;

    public function __construct(ReportGroupRepository $repository)
    {
        $this->finder = new DomainReportGroupCounter($repository);
    }

    public function __invoke(GroupDateStart $dateStart, GroupDateEnd $dateEnd) {
        return $this->finder->__invoke($dateStart, $dateEnd);
    }
}
